function InitDrillCategory()
	--KillDrill();
	if GAMESTATE:GetNumPlayersEnabled()<=1 then
		setenv("drFile",nil);
		setenv("drInfo",nil);
		setenv("Drill",true);
	--	setenv("EventMode",GAMESTATE:IsEventMode());
		SetUserPref_Theme("DrillEventMode",GAMESTATE:IsEventMode());
		GAMESTATE:SetTemporaryEventMode(true);
		setenv("DrillPlayer",(GAMESTATE:IsHumanPlayer(PLAYER_1)) and PLAYER_1 or PLAYER_2);
		local drFolder=FILEMAN:GetDirListing("./Drills/",true,true);

		local drFile={};
		local drInfo={};
		local drCnt=0;

		for df=1,#drFolder do
			local crsList=FILEMAN:GetDirListing(drFolder[df].."/",false,true);
			for crs=1,#crsList do
				if string.find(string.lower(crsList[crs]),".*%.crs$") then
					--[[
					local tmp=split("/",drFolder[df]);
					drFolder[df]=tmp[#tmp];
					--]]
					local tmp=split("/",crsList[crs]);
					crsList[crs]=tmp[#tmp];
					local drData=GetTextBlock(drFolder[df].."/"..crsList[crs],"main");
					if string.find(string.lower(GAMESTATE:GetCurrentStyle():GetStepsType()),
						"^.*_"..string.lower(GetBlockPrm(drData,"PLAYSTYLE")).."$") then
						drCnt=drCnt+1;
						drFile[drCnt]=drFolder[df].."/"..crsList[crs];
						drInfo[""..drFile[drCnt].."-Path"]=drFolder[df];
						drInfo[""..drFile[drCnt].."-File"]=drFolder[df].."/"..crsList[crs];
						local tmp=split("/",drFolder[df].."/"..crsList[crs]);
						drInfo[""..drFile[drCnt].."-File"]=tmp[#tmp-1].."_"..tmp[#tmp];
						drInfo[""..drFile[drCnt].."-Title"]=GetBlockPrm(drData,"DRILL");
						drInfo[""..drFile[drCnt].."-Color"]=GetBlockPrm(drData,"MENUCOLOR");
						drInfo[""..drFile[drCnt].."-Ctrl"] =GetBlockPrm(drData,"CONTROLLER");
						drInfo[""..drFile[drCnt].."-Style"]=string.lower(GetBlockPrm(drData,"PLAYSTYLE"));
						drInfo[""..drFile[drCnt].."-Life"] =string.lower(GetBlockPrm(drData,"LIFEMETER"));
						drInfo[""..drFile[drCnt].."-LDif"] =GetBlockPrm(drData,"LIFEDIFFICULTY");
						drInfo[""..drFile[drCnt].."-TDif"] =GetBlockPrm(drData,"TIMINGDIFFICULTY");
						drInfo[""..drFile[drCnt].."-Recovery"]=GetBlockPrm(drData,"RECOVERY");
						drInfo[""..drFile[drCnt].."-SOpt"]  =GetBlockPrm(drData,"STATICOPTIONS");
						if drInfo[""..drFile[drCnt].."-SOpt"]=="" then
							drInfo[""..drFile[drCnt].."-SOpt"]=GetBlockPrm(drData,"PLAYEROPTIONS");
						end;
						drInfo[""..drFile[drCnt].."-SOpt"]=string.lower(drInfo[""..drFile[drCnt].."-SOpt"]);
						drInfo[""..drFile[drCnt].."-ROpt"]=GetBlockPrm(drData,"REALTIMEOPTIONS");
						if drInfo[""..drFile[drCnt].."-ROpt"]=="" then
							drInfo[""..drFile[drCnt].."-ROpt"]=GetBlockPrm(drData,"GAMEPLAYOPTIONS");
						end;
						drInfo[""..drFile[drCnt].."-ROpt"]=string.lower(drInfo[""..drFile[drCnt].."-ROpt"]);
						drInfo[""..drFile[drCnt].."-Banner"]=drFolder[df].."/"..GetBlockPrm(drData,"BANNER");
						if GetBlockPrm(drData,"BANNER")=="" or not FILEMAN:DoesFileExist(drInfo[""..drFile[drCnt].."-Banner"]) then
							drInfo[""..drFile[drCnt].."-Banner"]=THEME:GetPathG("Common fallback","banner");
						end;
						drInfo[""..drFile[drCnt].."-Jacket"]=drFolder[df].."/"..GetBlockPrm(drData,"JACKET");
						if GetBlockPrm(drData,"JACKET")=="" or not FILEMAN:DoesFileExist(drInfo[""..drFile[drCnt].."-Jacket"]) then
							drInfo[""..drFile[drCnt].."-Jacket"]=THEME:GetPathG("Common fallback","jacket");
						end;
						drInfo[""..drFile[drCnt].."-Border"]=GetBlockPrm(drData,"CLEARBORDER");
						drInfo[""..drFile[drCnt].."-Background"]=GetBlockPrm(drData,"BACKGROUND");
						drInfo[""..drFile[drCnt].."-Bgm"]=GetBlockPrm(drData,"BGM");
						drInfo[""..drFile[drCnt].."-ResultBackground"]=GetBlockPrm(drData,"RESULTBACKGROUND");
						if drInfo[""..drFile[drCnt].."-ResultBackground"]=="" then
							drInfo[""..drFile[drCnt].."-ResultBackground"]=GetBlockPrm(drData,"RESULTBG");
						end;
						-- [ja] BGMと背景はファイル名だけで登録し、空白文字でなければディレクトリを追加する 
						if drInfo[""..drFile[drCnt].."-Background"]~="" then
							drInfo[""..drFile[drCnt].."-Background"]=drFolder[df].."/"..drInfo[""..drFile[drCnt].."-Background"];
						end;
						if drInfo[""..drFile[drCnt].."-Bgm"]~="" then
							drInfo[""..drFile[drCnt].."-Bgm"]=drFolder[df].."/"..drInfo[""..drFile[drCnt].."-Bgm"];
						end;
						if drInfo[""..drFile[drCnt].."-ResultBackground"]~="" then
							drInfo[""..drFile[drCnt].."-ResultBackground"]=drFolder[df].."/"..drInfo[""..drFile[drCnt].."-ResultBackground"];
						end;
						-- [ja] 空白文字だと困るパラメータの定義 
						if drInfo[""..drFile[drCnt].."-Color"]=="" then
							drInfo[""..drFile[drCnt].."-Color"]="0.92,0.11,0.47,1.0";
						end;
						if drInfo[""..drFile[drCnt].."-LDif"]=="" then
							drInfo[""..drFile[drCnt].."-LDif"]="1.0";
						end;
						if drInfo[""..drFile[drCnt].."-TDif"]=="" then
							drInfo[""..drFile[drCnt].."-TDif"]="1.0";
						end;
						if not tonumber(drInfo[""..drFile[drCnt].."-Recovery"]) then
							drInfo[""..drFile[drCnt].."-Recovery"]="0.0";
						end;
						if not tonumber(drInfo[""..drFile[drCnt].."-Border"]) then
							drInfo[""..drFile[drCnt].."-Border"]="0.0";
						end;
					end;
				end;
			end;
		end;

		if GetUserPref_Theme("DrillOldLLevel") and GetUserPref_Theme("DrillOldLLevel")~="" then
			PREFSMAN:SetPreference("LifeDifficultyScale",GetUserPref_Theme("DrillOldLLevel"));
		end;
		if GetUserPref_Theme("DrillOldTLevel") and GetUserPref_Theme("DrillOldTLevel")~="" then
			PREFSMAN:SetPreference("TimingWindowScale",GetUserPref_Theme("DrillOldTLevel"));
		end;
		if GetUserPref_Theme("DrillOldW1") and GetUserPref_Theme("DrillOldTLevel")~="" then
			PREFSMAN:SetPreference("AllowW1",GetUserPref_Theme("DrillOldW1"));
		end;
		SetUserPref_Theme("DrillOldLLevel",PREFSMAN:GetPreference("LifeDifficultyScale"));
		SetUserPref_Theme("DrillOldTLevel",PREFSMAN:GetPreference("TimingWindowScale"));
		SetUserPref_Theme("DrillOldW1",PREFSMAN:GetPreference("AllowW1"));
	--	setenv("DrillOldLLevel",PREFSMAN:GetPreference("LifeDifficultyScale"));
	--	setenv("DrillOldTLevel",PREFSMAN:GetPreference("AllowW1"));
	--	setenv("DrillOldW1",PREFSMAN:GetPreference("AllowW1"));
		PREFSMAN:SetPreference("AllowW1","AllowW1_Everywhere");
		local pdir=PROFILEMAN:GetProfileDir('ProfileSlot_Player1');
		if pdir=="" then
			pdir=PROFILEMAN:GetProfileDir('ProfileSlot_Machine');
		end;
		setenv("DrillProfileDir",pdir);
		
		local DrillPrfClear={};
		for i=1,drCnt do
		-- [ja] スコアの読み込み 
			drMax=1;
			while(true) do
				local drlData=GetTextBlock(drFile[i],"level"..drMax);
				if drlData=="" then
					break;
				end;
				drMax=drMax+1;
			end;
			drInfo[""..drFile[i].."-ClearLevel"]=0;
			drInfo[""..drFile[i].."-ClearName"]="NO DATA";
			for j=1,drMax do
				local drpData=GetTextBlock(getenv("DrillProfileDir").."Drills/"..drInfo[""..drFile[i].."-File"].."/Level"..j..".sav","main");
				local drpClear=GetBlockPrm(drpData,"clear");
				if drpClear~="" and drpClear~="0" and j>drInfo[""..drFile[i].."-ClearLevel"] then
					local drpCombo=tonumber(GetBlockPrm(drpData,"combo"));
					local drpDP=math.floor(tonumber(GetBlockPrm(drpData,"dancepoints"))*100);
					--if (tonumber(drpClear)/2-drpDP)==drpCombo then	-- [ja] elseなら不正なデータ 
						drInfo[""..drFile[i].."-ClearLevel"]=j;
						drInfo[""..drFile[i].."-ClearName"]=GetBlockPrm(drpData,"name");
						if drInfo[""..drFile[i].."-ClearName"]=="" then
							drInfo[""..drFile[i].."-ClearName"]="Level"..j;
						end;
					--end;
				end;
			end;
		end;
		setenv("drFile",drFile);
		setenv("drInfo",drInfo);
	end;
end;

function KillDrill()
	if getenv("Drill") then
		setenv("sys_seldrill",1);
		setenv("sys_sellevel",1);
		setenv("Drill",false);
		setenv("DrillLife",false);
		setenv("DrillLifeRemaining",false);
		PREFSMAN:SetPreference("LifeDifficultyScale",GetUserPref_Theme("DrillOldLLevel"));
		PREFSMAN:SetPreference("TimingWindowScale",GetUserPref_Theme("DrillOldTLevel"));
		PREFSMAN:SetPreference("AllowW1",GetUserPref_Theme("DrillOldW1"));
	--	setenv("DrillOldLLevel",false);
	--	setenv("DrillOldTLevel",false);
		if GetUserPref_Theme("DrillEventMode") or GetUserPref_Theme("DrillEventMode")=="" then
			GAMESTATE:SetTemporaryEventMode(tobool(GetUserPref_Theme("DrillEventMode")));
			SetUserPref_Theme("DrillEventMode","");
		end;
		SetUserPref_Theme("DrillOldLLevel","");
		SetUserPref_Theme("DrillOldTLevel","");
		SetUserPref_Theme("DrillOldW1","");
		setenv("DrillProfileDir",false);
		setenv("DrillPlayer",false);
	end;
end;

function DrillSelectMusic_in()
	local ActorDrill=Def.ActorFrame{
		InitCommand=function(self)
			if not getenv("Announcers") then
				InputCurrentAnnouncer();
				MuteAnnouncer();
			end;
		end;
		OnCommand=function(self)
			if getenv("Drill") then
				if string.find(getenv("DrillChk"),"SetStage%d+") then
					local stage=getenv("DrillStage");
					local drInfo={};
					drInfo=getenv("drInfo");
					local lvInfo={};
					lvInfo=getenv("lvInfo");
					if stage>getenv("DrillMaxStage") then
						SCREENMAN:SetNewScreen("ScreenSelectDrillDifficulty");
					end;
					local sys_sellevel=getenv("sys_sellevel");
					local path,song,dif=GetDrillSong(lvInfo[""..sys_sellevel.."-Song"][stage]);
					ResetAnnouncer();
					if song then
						GAMESTATE:SetCurrentSong(song);	--[ja] 強制曲設定 
						GAMESTATE:SetCurrentSteps(getenv("DrillPlayer"),
							song:GetOneSteps(GAMESTATE:GetCurrentStyle():GetStepsType(),dif));
						setenv("DrillChk","PlayStage"..stage);
						if drInfo["SOpt"]=="true" and stage<=1 then
							SCREENMAN:SetNewScreen("ScreenPlayerOptions");
						else
							if drInfo["SOpt"]=="false" and stage<=1 then
								-- [ja] 強制倍速1x 
								local ps = GAMESTATE:GetPlayerState(GAMESTATE:GetMasterPlayerNumber());
								local po_so=ps:GetPlayerOptions('ModsLevel_Song');
								po_so:CMod(1,9999);
								po_so:XMod(1,9999);
								local po_pr=ps:GetPlayerOptions('ModsLevel_Preferred');
								po_pr:CMod(1,9999);
								po_pr:XMod(1,9999);
								if GetSMVersion()<=30 then
									local modstr = "default, " .. ps:GetPlayerOptionsString("ModsLevel_Preferred")..", C1, 1x";
									ps:SetPlayerOptions("ModsLevel_Preferred", modstr);
								end;
							end;
							SCREENMAN:SetNewScreen("ScreenStageInformation");
						end;
					else
						SCREENMAN:SetNewScreen("ScreenSelectDrillDifficulty");
					end;
				elseif string.find(getenv("DrillChk"),"PlayStage%d+") then
					ResetAnnouncer();
					SCREENMAN:SetNewScreen("ScreenSelectDrillDifficulty");
				elseif getenv("DrillChk")=="Finish" then
					ResetAnnouncer();
					if GetUserPref_Theme("DrillEventMode")=="false" then
						-- [ja] イベントモードではないのでゲーム終了 
						KillDrill();
						SCREENMAN:SetNewScreen("ScreenGameOver");
					else
						SCREENMAN:SetNewScreen("ScreenSelectDrillDifficulty");
					end;
				end;
			end;
		end;
	};
	return ActorDrill;
end;

-- [ja] コース書式の#SONGからディレクトリとsong型と難易度を返す 
function GetDrillSong(strSong)
	local tmp=split(":",strSong);
	tmp[1]=string.gsub(tmp[1],"\\","/");
	local path=split("/",tmp[1]);
	local song=GetFolder2Song(path[#path-1],path[#path]);
	local dif_name=string.lower(tmp[2]);
	local dif='Difficulty_Easy';
	if dif_name=="beginner" then
		dif='Difficulty_Beginner';
	elseif dif_name=="normal" or dif_name=="basic"
		or dif_name=="light" or dif_name=="easy" then
		dif='Difficulty_Easy';
	elseif dif_name=="another" or dif_name=="trick"
		or dif_name=="standard" or dif_name=="medium" then
		dif='Difficulty_Medium';
	elseif dif_name=="maniac" or dif_name=="ssr"
		or dif_name=="heavy" or dif_name=="hard" then
		dif='Difficulty_Hard';
	elseif dif_name=="challenge" or dif_name=="oni"
		or dif_name=="smaniac" then
		dif='Difficulty_Challenge';
	elseif dif_name=="edit" then
		dif='Difficulty_Edit';
	else
		dif='Difficulty_Easy';
	end;
	return path,song,dif;
end;

function DrillGameplay()
	local ActorDrill=Def.ActorFrame{
		BeginCommand=function(self)
			if getenv("Drill") then
				if tonumber(getenv("DrillLife")) and getenv("DrillLifeRemaining") then
					-- [ja] 1以上のバッテリーライフ 
					local life=1.0;
					if getenv("DrillLifeRecovery")>=0 then
						life=math.floor(getenv("DrillLife")*getenv("DrillLifeRemaining")+0.9)-getenv("DrillLife");
					else
						life=getenv("DrillLife")-SCREENMAN:GetTopScreen():GetLifeMeter(getenv("DrillPlayer")):GetLivesLeft();
					end;
					SCREENMAN:GetTopScreen():GetLifeMeter(getenv("DrillPlayer")):ChangeLives(life);
				end;
			end;
		end;
		OffCommand=function(self)
			if getenv("Drill") then
				self:sleep(2.5);
				if string.find(getenv("DrillChk"),"PlayStage%d+") then
					SetDrillScore(getenv("DrillStage"));
					if not getenv("DrillFailed") then
						local life=SCREENMAN:GetTopScreen():GetLifeMeter(getenv("DrillPlayer")):GetLife();
						setenv("DrillLifeRemaining",life)
						if getenv("DrillStage")+1>getenv("DrillMaxStage") then
							setenv("DrillChk","Finish");
							-- [ja] クリア 
						else
							setenv("DrillStage",getenv("DrillStage")+1);
							setenv("DrillChk","SetStage"..getenv("DrillStage"));
							-- [ja] 次ステージ 
						end;
					else
						-- [ja] Failed 
						setenv("DrillChk","Finish");
							-- [ja] リザルトへ 
					end;
				elseif getenv("DrillChk")~="Finish" then
					-- [ja] 異常事態 
					self:queuecommand("DrillError");
				end;
			end;
		end;
		DrillErrorCommand=function(self)
			_SYS("ERROR : "..getenv("DrillChk"))
			SCREENMAN:SetNewScreen("ScreenSelectDrillDifficulty");
		end;
	};
	local function DrillUpdate()
		if getenv("Drill") and not getenv("DrillFailed") then
			if GAMESTATE:GetPlayerState(getenv("DrillPlayer")):GetHealthState()=='HealthState_Dead' then
				setenv("DrillFailed",true);
				local dif=GAMESTATE:GetCurrentSteps(getenv("DrillPlayer")):GetDifficulty();
				if dif==Difficulty[1] or dif==Difficulty[2] then
					SCREENMAN:GetTopScreen():PostScreenMessage('SM_Pause', 0.5);
					SCREENMAN:GetTopScreen():PostScreenMessage('SM_BeginFailed', 0.5);
				end;
			end;
		end;
	end;
	ActorDrill.InitCommand=cmd(SetUpdateFunction,DrillUpdate);
	return ActorDrill;
end;

function DrillEvaluation_in()
	-- [ja] GameplayのOffから次ステージへ遷移するとプレイ中に戻った扱いされてスコアが保存されない？のでこちらで対処 
	local ActorDrill=Def.ActorFrame{
		InitCommand=function(self)
			if not getenv("Drill") then
				ResetAnnouncer();
			end;
		end;
		OnCommand=function(self)
			if getenv("Drill") then
				if getenv("DrillChk")=="Finish" then
					SCREENMAN:SetNewScreen("ScreenDrillEvaluation");
				else
					if not getenv("DrillFailed") then
						if getenv("DrillLifeRecovery")>=0 then
							setenv("DrillLifeRemaining",math.min(math.max(getenv("DrillLifeRemaining")+getenv("DrillLifeRecovery"),0),1));
						end;
						SCREENMAN:SetNewScreen("ScreenSelectMusic");
					else
						setenv("DrillChk","Finish");
						SCREENMAN:SetNewScreen("ScreenDrillEvaluation");
					end;
				end;
			end;
		end;
	};
	return ActorDrill;
end;

function ReadDrillData(drFile,drInfo)
-- [ja] 全ドリルカテゴリ情報を保持し続けるとメモリがもったいないので選択したもの以外破棄 
	setenv("drFile",drFile);
	local tmp={};
	tmp["Path"]=drInfo[""..drFile.."-Path"];
	tmp["File"]=drInfo[""..drFile.."-File"];
	tmp["Title"]=drInfo[""..drFile.."-Title"];
	tmp["Color"]=drInfo[""..drFile.."-Color"];
	tmp["Ctrl"] =drInfo[""..drFile.."-Ctrl"];
	tmp["Style"]=drInfo[""..drFile.."-Style"];
	tmp["Life"] =drInfo[""..drFile.."-Life"];
	tmp["LDif"] =drInfo[""..drFile.."-LDif"];
	tmp["Recovery"]=drInfo[""..drFile.."-Recovery"];
	tmp["TDif"] =drInfo[""..drFile.."-TDif"];
	tmp["SOpt"] =drInfo[""..drFile.."-SOpt"];
	tmp["ROpt"]	=drInfo[""..drFile.."-ROpt"];
	tmp["Banner"]=drInfo[""..drFile.."-Banner"];
	tmp["Jacket"]=drInfo[""..drFile.."-Jacket"];
	tmp["Border"]=drInfo[""..drFile.."-Border"];
	tmp["ClearLevel"]=drInfo[""..drFile.."-ClearLevel"];
	tmp["ClearName"]=drInfo[""..drFile.."-ClearName"];
	tmp["Background"]=drInfo[""..drFile.."-Background"];
	tmp["Bgm"]=drInfo[""..drFile.."-Bgm"];
	tmp["ResultBackground"]=drInfo[""..drFile.."-ResultBackground"];
--
	local lvInfo={};
	local drLevel=1;
	while(true) do
		local drlData=GetTextBlock(drFile,"level"..drLevel);
		if drlData=="" then
			break;
		else
			lvInfo[""..drLevel.."-Banner"]=tmp["Path"].."/"..GetBlockPrm(drlData,"BANNER");
			if GetBlockPrm(drlData,"BANNER")=="" or not FILEMAN:DoesFileExist(lvInfo[""..drLevel.."-Banner"]) then
				lvInfo[""..drLevel.."-Banner"]=THEME:GetPathG("Common fallback","banner");
			end;
			lvInfo[""..drLevel.."-Jacket"]=tmp["Path"].."/"..GetBlockPrm(drlData,"JACKET");
			if GetBlockPrm(drlData,"JACKET")=="" or not FILEMAN:DoesFileExist(lvInfo[""..drLevel.."-Jacket"]) then
				lvInfo[""..drLevel.."-Jacket"]=THEME:GetPathG("Common fallback","jacket");
			end;
			lvInfo[""..drLevel.."-Color"]=GetBlockPrm(drlData,"MENUCOLOR");
			lvInfo[""..drLevel.."-Song"]=GetBlockPrm2(drlData,"SONG");
			lvInfo[""..drLevel.."-Name"]=GetBlockPrm(drlData,"NAME");
			-- [ja] 空白文字だと困るパラメータの定義 
			if lvInfo[""..drLevel.."-Name"]=="" then
				lvInfo[""..drLevel.."-Name"]="Level"..drLevel;
			end;
			if lvInfo[""..drLevel.."-Color"]=="" then
				lvInfo[""..drLevel.."-Color"]="0.92,0.11,0.47,1.0";
			end;
		end;
		drLevel=drLevel+1;
	end;
	tmp["Level"]=drLevel-1;	-- [ja] 最高レベル 
	setenv("drInfo",tmp);
	setenv("lvInfo",lvInfo);
end;

function DrillDificultyInit()
	local drInfo={};
	drInfo=getenv("drInfo");
	local lvInfo={};
	lvInfo=getenv("lvInfo");
	local lvScore={};
	-- [ja] セーブデータの読み取り 
	for i=1,drInfo["Level"] do
		lvScore[""..i.."-Clear"]=false;
		lvScore[""..i.."-DP"]=0.0;
		lvScore[""..i.."-PlayCnt"]=0;
		lvScore[""..i.."-ClearCnt"]=0;
		local drpData=GetTextBlock(getenv("DrillProfileDir").."Drills/"..drInfo["File"].."/Level"..i..".sav","main");
		if drpData~="" then
			local drpClear=GetBlockPrm(drpData,"clear");
			if drpClear~="" and drpClear~="0" then
				local drpCombo=tonumber(GetBlockPrm(drpData,"combo"));
				local drpDP=math.floor(tonumber(GetBlockPrm(drpData,"dancepoints"))*100);
				--if (tonumber(drpClear)/2-drpDP)==drpCombo then	-- [ja] elseなら不正なデータ 
					lvScore[""..i.."-Clear"]=true;
				--end;
			end;
			lvScore[""..i.."-DP"]=tonumber(GetBlockPrm(drpData,"dancepoints"));
			local drpCnt=GetBlockPrm(drpData,"count");
			if drpCnt~="" then
				local tmp=split(":",drpCnt);
				lvScore[""..i.."-PlayCnt"]=tonumber(tmp[1]);
				lvScore[""..i.."-ClearCnt"]=tonumber(tmp[2]);
			end;
		end;
	end;
	setenv("lvScore",lvScore);
end;

-- [ja] ドリル時のライフを設定 
function SetDrillLife()
	local drInfo={};
	drInfo=getenv("drInfo");
	setenv("DrillFailed",false);
	setenv("DrillLifeRemaining",false);
	local lLife=string.lower(drInfo["Life"]);
	if lLife=="ultimate" then
		setenv("DrillLife","Ultimate");
	elseif lLife=="hard" then
		setenv("DrillLife","Hard");
	elseif lLife=="norecover" then
		setenv("DrillLife","NoRecover");
	elseif lLife=="hardnorecover" then
		setenv("DrillLife","Hard");
	elseif lLife=="suddendeath" then
		setenv("DrillLife","SuddenDeath");
	elseif tonumber(drInfo["Life"]) then
		setenv("DrillLife",""..math.max(tonumber(drInfo["Life"]),1));
	elseif lLife=="mfc" or lLife=="w1fc" then
		setenv("DrillLife","MFC");
	elseif lLife=="pfc" or lLife=="w2fc" then
		setenv("DrillLife","PFC");
	elseif lLife=="fc" or lLife=="w3fc" then
		setenv("DrillLife","FC");
	else
		setenv("DrillLife","Normal");
	end;
	if string.find(getenv("DrillLife"),"^%d$") then
		-- [ja] バッテリーライフ 
		if GetSMVersion()>30 then
			for p=1,2 do
				local pn=(p==1) and PLAYER_1 or PLAYER_2;
				if GAMESTATE:IsPlayerEnabled(pn) then
					local ps=GAMESTATE:GetPlayerState(pn);
					if ps then
						local po=ps:GetPlayerOptions('ModsLevel_Preferred');
						po:LifeSetting('LifeType_Battery');
						po:BatteryLives(tonumber(getenv("DrillLife")));
					end;
				end;
			end;
		else
			GAMESTATE:ApplyGameCommand( "mod,battery");
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			GAMESTATE:ApplyGameCommand( "mod,"..getenv("DrillLife").."lives");
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
		end;
		setenv("DrillMaxLife",tonumber(getenv("DrillLife")));
	elseif getenv("DrillLife")=="MFC" or getenv("DrillLife")=="PFC" or getenv("DrillLife")=="FC" then
		-- [ja] バッテリーライフ（残量1） 
		if GetSMVersion()>30 then
			for p=1,2 do
				local pn=(p==1) and PLAYER_1 or PLAYER_2;
				if GAMESTATE:IsPlayerEnabled(pn) then
					local ps=GAMESTATE:GetPlayerState(pn);
					if ps then
						local po=ps:GetPlayerOptions('ModsLevel_Preferred');
						po:LifeSetting('LifeType_Battery');
						po:BatteryLives(1);
					end;
				end;
			end;
		else
			GAMESTATE:ApplyGameCommand( "mod,battery");
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			GAMESTATE:ApplyGameCommand( "mod,1lives");
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
		end;
		setenv("DrillMaxLife",1);
	else
		if tonumber(drInfo["LDif"]) then
			PREFSMAN:SetPreference("LifeDifficultyScale",math.max(drInfo["LDif"],0.01));
		end;
		if tonumber(drInfo["TDif"]) then
			PREFSMAN:SetPreference("TimingWindowScale",math.max(drInfo["TDif"],0.01));
		end;
		if GetSMVersion()>30 then
			for p=1,2 do
				local pn=(p==1) and PLAYER_1 or PLAYER_2;
				if GAMESTATE:IsPlayerEnabled(pn) then
					local ps=GAMESTATE:GetPlayerState(pn);
					if ps then
						local po=ps:GetPlayerOptions('ModsLevel_Preferred');
						po:LifeSetting('LifeType_Bar');
						if lLife=="norecover" or lLife=="hardnorecover" then
							po:DrainSetting('DrainType_NoRecover');
						elseif lLife=="norecover" or lLife=="suddendeath" then
							po:DrainSetting('DrainType_SuddenDeath');
						else
							po:DrainSetting('DrainType_Normal');
						end;
					end;
				end;
			end;
		else
			GAMESTATE:ApplyGameCommand( "mod,bar");
			MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			if lLife=="norecover" or lLife=="hardnorecover" then
				GAMESTATE:ApplyGameCommand( "mod,norecover");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			elseif lLife=="norecover" or lLife=="suddendeath" then
				GAMESTATE:ApplyGameCommand( "mod,suddendeath");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			else
				GAMESTATE:ApplyGameCommand( "mod,normal-drain");
				MESSAGEMAN:Broadcast( "SongOptionsChanged" );
			end;
		end;
		setenv("DrillMaxLife",0);	-- [ja] 0の場合通常ライフ 
	end;
	setenv("DrillLifeRecovery",tonumber(drInfo["Recovery"]));
end;

function InitDrillScore(maxstage)
	local DrillScore={};
	-- [ja] トータル 
	DrillScore["Drill_W1"]=0;
	DrillScore["Drill_W2"]=0;
	DrillScore["Drill_W3"]=0;
	DrillScore["Drill_W4"]=0;
	DrillScore["Drill_W5"]=0;
	DrillScore["Drill_MS"]=0;
	DrillScore["Drill_OK"]=0;
	DrillScore["Drill_NG"]=0;
	DrillScore["Drill_HIT"]=0;
	DrillScore["Drill_COMBO"]=0;
	DrillScore["Drill_DP"]=0;	--[ja] 平均DP 
	DrillScore["Drill_LIFE"]=0;	--[ja] 平均ライフ 
	DrillScore["Drill_CAL"]=0;	--[ja] 合計消費カロリー 
	-- [ja] ステージ毎 
	for i=1,maxstage do
		DrillScore["Drill_W1-"..i]=0;
		DrillScore["Drill_W2-"..i]=0;
		DrillScore["Drill_W3-"..i]=0;
		DrillScore["Drill_W4-"..i]=0;
		DrillScore["Drill_W5-"..i]=0;
		DrillScore["Drill_MS-"..i]=0;
		DrillScore["Drill_OK-"..i]=0;
		DrillScore["Drill_NG-"..i]=0;
		DrillScore["Drill_HIT-"..i]=0;
		DrillScore["Drill_COMBO-"..i]=0;
		DrillScore["Drill_DP-"..i]=0;
		DrillScore["Drill_LIFE-"..i]=0;
		DrillScore["Drill_CAL-"..i]=0;
	end;
	setenv("DrillScore",DrillScore);
	local DrillLifeStats={};
	setenv("DrillLifeStats",DrillLifeStats);
end;

function SetDrillScore(curstage)
	local DrillScore=getenv("DrillScore");
	local pss=STATSMAN:GetCurStageStats():GetPlayerStageStats(getenv("DrillPlayer"));
	DrillScore["Drill_W1-"..curstage]   =pss:GetTapNoteScores('TapNoteScore_W1');
	DrillScore["Drill_W2-"..curstage]   =pss:GetTapNoteScores('TapNoteScore_W2');
	DrillScore["Drill_W3-"..curstage]   =pss:GetTapNoteScores('TapNoteScore_W3');
	DrillScore["Drill_W4-"..curstage]   =pss:GetTapNoteScores('TapNoteScore_W4');
	DrillScore["Drill_W5-"..curstage]   =pss:GetTapNoteScores('TapNoteScore_W5');
	DrillScore["Drill_MS-"..curstage]   =pss:GetTapNoteScores('TapNoteScore_Miss');
	DrillScore["Drill_OK-"..curstage]   =pss:GetHoldNoteScores('HoldNoteScore_Held');
	DrillScore["Drill_NG-"..curstage]   =pss:GetHoldNoteScores('HoldNoteScore_LetGo');
	DrillScore["Drill_HIT-"..curstage]  =pss:GetTapNoteScores('TapNoteScore_HitMine');
	DrillScore["Drill_COMBO-"..curstage]=pss:MaxCombo();
	DrillScore["Drill_DP-"..curstage]   =pss:GetPercentDancePoints();
	DrillScore["Drill_LIFE-"..curstage] =SCREENMAN:GetTopScreen():GetLifeMeter(getenv("DrillPlayer")):GetLife();
	DrillScore["Drill_CAL-"..curstage] = (getenv("DrillPlayer")==PLAYER_1) and getenv("cal1") or getenv("cal2");
	setenv("DrillScore",DrillScore);
end;

-- [ja] クリア判別とデータ保存 
function SetDrillResult()
	local drInfo=getenv("drInfo");
	local lvInfo=getenv("lvInfo");
	local lvScore=getenv("lvScore");
	local sys_sellevel=getenv("sys_sellevel");
	local DrillScore=getenv("DrillScore");
	DrillScore["Drill_DP"]=0
	for i=1,getenv("DrillMaxStage") do
		DrillScore["Drill_W1"]   =DrillScore["Drill_W1"]+DrillScore["Drill_W1-"..i];
		DrillScore["Drill_W2"]   =DrillScore["Drill_W2"]+DrillScore["Drill_W2-"..i];
		DrillScore["Drill_W3"]   =DrillScore["Drill_W3"]+DrillScore["Drill_W3-"..i];
		DrillScore["Drill_W4"]   =DrillScore["Drill_W4"]+DrillScore["Drill_W4-"..i];
		DrillScore["Drill_W5"]   =DrillScore["Drill_W5"]+DrillScore["Drill_W5-"..i];
		DrillScore["Drill_MS"]   =DrillScore["Drill_MS"]+DrillScore["Drill_MS-"..i];
		DrillScore["Drill_OK"]   =DrillScore["Drill_OK"]+DrillScore["Drill_OK-"..i];
		DrillScore["Drill_NG"]   =DrillScore["Drill_NG"]+DrillScore["Drill_NG-"..i];
		DrillScore["Drill_HIT"]  =DrillScore["Drill_HIT"]+DrillScore["Drill_HIT-"..i];
		DrillScore["Drill_COMBO"]=DrillScore["Drill_COMBO"]+DrillScore["Drill_COMBO-"..i];
		DrillScore["Drill_DP"]   =DrillScore["Drill_DP"]+DrillScore["Drill_DP-"..i];
		DrillScore["Drill_LIFE"] =DrillScore["Drill_LIFE"]+DrillScore["Drill_LIFE-"..i];
		DrillScore["Drill_CAL"] =DrillScore["Drill_CAL"]+DrillScore["Drill_CAL-"..i];
	end;
	DrillScore["Drill_DP"]=DrillScore["Drill_DP"]/getenv("DrillMaxStage");
	DrillScore["Drill_LIFE"]=DrillScore["Drill_LIFE"]/getenv("DrillMaxStage");
	setenv("DrillScore",DrillScore);
	if tonumber(string.format("%1.2f",DrillScore["Drill_DP"]*100))<tonumber(drInfo["Border"]) then
		setenv("DrillFailed",true);
	end;
	if not getenv("DrillFailed") then
		lvScore[""..sys_sellevel.."-ClearCnt"]=lvScore[""..sys_sellevel.."-ClearCnt"]+1;
	end;
	local tmp=split("/",drInfo["File"]);
	local drpMain=GetTextBlock(getenv("DrillProfileDir").."Drills/"..drInfo["File"].."/Level"..sys_sellevel..".sav","main");
	local drpClear=GetBlockPrm(drpMain,"Clear");
	local drpDP=GetBlockPrm(drpMain,"DancePoints");
	if drpMain=="" or (((drpClear=="0" and not getenv("DrillFailed")) or DrillScore["Drill_DP"]>tonumber(drpDP))
		and not (drpClear~="0" and getenv("DrillFailed"))) then
		local saveText="";
		saveText=saveText.."[Main]\n";
		saveText=saveText.."#Name:"..lvInfo[""..sys_sellevel.."-Name"]..";\n";
		--saveText=saveText.."#Clear:"..(getenv("DrillFailed") and 0 or ((math.floor(DrillScore["Drill_DP"]*100)+DrillScore["Drill_COMBO"])*2))..";\n";
		saveText=saveText.."#Clear:"..(getenv("DrillFailed") and 0 or 1)..";\n";	-- [ja] 暗号化なんていらないんや… 
		saveText=saveText.."#NoteScore:"..DrillScore["Drill_W1"]..":"
			..DrillScore["Drill_W2"]..":"..DrillScore["Drill_W3"]..":"
			..DrillScore["Drill_W4"]..":"..DrillScore["Drill_W5"]..":"
			..DrillScore["Drill_MS"]..":"..DrillScore["Drill_OK"]..":"
			..DrillScore["Drill_NG"]..":"..DrillScore["Drill_HIT"]..";\n";
		saveText=saveText.."#Combo:"..DrillScore["Drill_COMBO"]..";\n";
		saveText=saveText.."#DancePoints:"..DrillScore["Drill_DP"]..";\n";
		saveText=saveText.."#Life:"..DrillScore["Drill_LIFE"]..";\n";
		saveText=saveText.."#Count:"..lvScore[""..sys_sellevel.."-PlayCnt"]..":"
			..lvScore[""..sys_sellevel.."-ClearCnt"]..";\n";
		for i=1,getenv("DrillMaxStage") do
			saveText=saveText.."\n[Stage"..i.."]\n";
			saveText=saveText.."#NoteScore:"..DrillScore["Drill_W1-"..i]..":"
				..DrillScore["Drill_W2-"..i]..":"..DrillScore["Drill_W3-"..i]..":"
				..DrillScore["Drill_W4-"..i]..":"..DrillScore["Drill_W5-"..i]..":"
				..DrillScore["Drill_MS-"..i]..":"..DrillScore["Drill_OK-"..i]..":"
				..DrillScore["Drill_NG-"..i]..":"..DrillScore["Drill_HIT-"..i]..";\n";
			saveText=saveText.."#Combo:"..DrillScore["Drill_COMBO-"..i]..";\n";
			saveText=saveText.."#DancePoints:"..DrillScore["Drill_DP-"..i]..";\n";
			saveText=saveText.."#Life:"..DrillScore["Drill_LIFE-"..i]..";\n";
		end;
		local f=SaveFile(getenv("DrillProfileDir").."Drills/"..drInfo["File"].."/Level"..sys_sellevel..".sav");
		f:Write(saveText);
		CloseFile(f);
	else
	-- [ja] スコアの更新がなくてもプレイ回数の更新が必要 
	-- [ja] カロリーは保存対象外 
		local saveText="";
		local tmp_drpMain=GetTextBlock(getenv("DrillProfileDir").."Drills/"..drInfo["File"].."/Level"..sys_sellevel..".sav","main");
		saveText=saveText.."[Main]\n";
		saveText=saveText.."#Name:"..GetBlockPrm(tmp_drpMain,"name")..";\n";
		saveText=saveText.."#Clear:"..GetBlockPrm(tmp_drpMain,"clear")..";\n";
		saveText=saveText.."#NoteScore:"..GetBlockPrm(tmp_drpMain,"notescore")..";\n";
		saveText=saveText.."#Combo:"..GetBlockPrm(tmp_drpMain,"combo")..";\n";
		saveText=saveText.."#DancePoints:"..GetBlockPrm(tmp_drpMain,"dancepoints")..";\n";
		saveText=saveText.."#Life:"..GetBlockPrm(tmp_drpMain,"life")..";\n";
		saveText=saveText.."#Count:"..lvScore[""..sys_sellevel.."-PlayCnt"]..":"
			..lvScore[""..sys_sellevel.."-ClearCnt"]..";\n";
		for i=1,getenv("DrillMaxStage") do
			local tmp_drpSection=GetTextBlock(getenv("DrillProfileDir").."Drills/"..drInfo["File"].."/Level"..sys_sellevel..".sav","stage"..i);
			saveText=saveText.."\n[Stage"..i.."]\n";
			saveText=saveText.."#NoteScore:"..GetBlockPrm(tmp_drpSection,"notescore")..";\n";
			saveText=saveText.."#Combo:"..GetBlockPrm(tmp_drpSection,"combo")..";\n";
			saveText=saveText.."#DancePoints:"..GetBlockPrm(tmp_drpSection,"dancepoints")..";\n";
			saveText=saveText.."#Life:"..GetBlockPrm(tmp_drpSection,"life")..";\n";
		end;
		local f=SaveFile(getenv("DrillProfileDir").."Drills/"..drInfo["File"].."/Level"..sys_sellevel..".sav");
		f:Write(saveText);
		CloseFile(f);
	end;
end;

-- [ja] プロファイルの保存形式 
--[[
+00000000
++Drills
+++Category1
+++-Level1.sav
+++-Level2.sav
+++Category2
+++-Level1.sav
+++-Level2.sav

*Level1.sav
[Main]
#Name:Level1;
//#Clear:0; ←0 : failed, (DP(%)の整数部+Combo)*2 : cleared
#Clear:0; ←0 : failed, 1 : cleared
#NoteScore:W1:W2:W3....;
#Combo:XXX;
#DancePoints:XXX;
#Life:XXX;
[Stage1]
#NoteScore:W1:W2:W3....;
#Combo:XXX...;
#DancePoints:XXX...;
#Life:XXX...;
]]--

-- [ja] ブロックの内容を取得する 
-- [ja] ここでいうブロック＝INIのセクションに相当 
--[=[
	[b_name]
	#XXX1:YYY1; ┐
	#XXX2:YYY2; ├この部分
	#XXX3:YYY3; ┘
	
	[hogehoge]
	XXX1:YYY1;
--]=]
function GetTextBlock(filePath,ub_name)
	if not FILEMAN:DoesFileExist(filePath) then
		return "";
	end;
	local b_name=string.lower(ub_name);
	local f=RageFileUtil.CreateRageFile();
	f:Open(filePath,1);

	local ret="";
	local loadblock=false;
	local l;
	while true do
		l=f:GetLine();
		local ll=string.lower(l);
		if (loadblock and string.find(ll,".*%[.+%]$"))
			or f:AtEOF() then
			break;
		elseif not loadblock and string.find(ll,".*%["..b_name.."%]$") then
			loadblock=true;
		elseif loadblock and ll~="" and not string.find(ll,"^%s+$")
			and not string.find(ll,"^//.*") then
			--[[
			if ret~="" then
				ret=ret.."\n";
			end;
			--]]
			l=string.gsub(l,"^%s",""); --[ja] 先頭の空白を削除 
			l=string.gsub(l,"%s$",""); --[ja] 終端の空白を削除 
			ret=ret..l;
		end;
	end;

	f:Close();
	f:destroy();
	return ret;
end;

-- [ja] INI書式の#ub_name:YYY;の内容を取得する 
function GetBlockPrm(blockStr,ub_name)
	if blockStr=="" then
		return "";
	end;
	local bStr=split(";",blockStr);
	local b_name=string.lower(ub_name);
	local ret="";
	for i=1,#bStr do
		if string.find(string.lower(bStr[i]),"^#"..b_name..":.*") then
			ret=""..split(":",bStr[i])[2];
			local tmp=split(":",bStr[i]);
			for p=3,#tmp do
				ret=ret..":"..tmp[p];
			end;
			break;
		end;
	end;
	return ret;
end;

-- [ja] INI書式の#ub_name:YYY;の内容を取得する 
-- [ja] #SONGのように複数定義されているもの専用 
-- [ja] テーブルとして返す 
function GetBlockPrm2(blockStr,ub_name)
	if blockStr=="" then
		return "";
	end;
	local bStr=split(";",blockStr);
	local b_name=string.lower(ub_name);
	local ret={};
	local r=0;
	for i=1,#bStr do
		if string.find(string.lower(bStr[i]),"^#"..b_name..":.*") then
			r=r+1;
			local tmp=split(":",bStr[i]);
			ret[r]=tmp[2];
			for p=3,#tmp do
				ret[r]=ret[r]..":"..tmp[p];
			end;
		end;
	end;
	return ret;
end;